<?php
session_start();

// Database connection
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "rb_kvalif_410";

$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// Ensure the user is logged in
$user_id = $_SESSION['user_id'] ?? null;
$first_name = "";
$last_name = "";

if ($user_id) {
    $sql = "SELECT first_name, last_name FROM rb_kvalif_signup_410 WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        $first_name = htmlspecialchars($row['first_name']); // Sanitize output
        $last_name = htmlspecialchars($row['last_name']);
    }

    $stmt->close();
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="../css/main.css">
    <title>Sākumlapa</title>
</head>
<body>
<header>
    <nav>
        <ul>
            <li><a href="../php/main.php" class="active">Home</a></li>
            <li><a href="../html/work-hours.html">Work hours</a></li>
            <li><a href="../html/material-count.html">Material count</a></li>
            <li><a href="../html/faq.html">FAQ</a></li>
        </ul>
        <div class="user-info">
            <!-- Corrected profile button -->
            <button class="profile-btn" onclick="location.href='../html/profile.html'">
                <img src="../icons/user.svg" alt="user icon">
            </button>
            <a href="../html/log-in.html" class="logout">Logout</a>
        </div>
    </nav>
</header>
<div class="content">
    <!-- Personalized welcome message -->
    <h2 id="welcome-message">Laipni lūdzam, <?php echo $first_name . " " . $last_name; ?>!</h2>

    <!-- Card Container -->
    <div class="card-container">
        <div class="card" onclick="location.href='../html/work-hours.html'">
            <img src="../icons/work-hours.svg" alt="Work Hours Icon">
            <p>Work hours</p>
        </div>
        <div class="card" onclick="location.href='../html/material-count.html'">
            <img src="../icons/material-count.svg" alt="Material Count Icon">
            <p>Material count</p>
        </div>
        <div class="card" onclick="location.href='../html/faq.html'">
            <img src="../icons/faq.svg" alt="FAQ Icon">
            <p>FAQ</p>
        </div>
    </div>
</div>
</body>
</html>
